#include "dbxurl.h"
#include <getopt.h>
#include <string.h>

/*
 * This function parses the command line for options and 
 * either bails out (if errors were found) or returns
 * a pointer to a (static) area that contains the proper
 * options.
 */
struct struct_options *get_options(int argc, char *const *argv)
{

    /* horses 
    */
    int c, n;
    char *argvv[argc];
   
    /* option markers
    */
    int h,T,t,b,a,V,optdouble;
    static struct struct_options options;

    static char * opts="T:t:b:a:Vh";
    static struct option long_options[] = {
	{ "beginbytes",                required_argument, NULL, 'T' },
	{ "endbytes",                  required_argument, NULL, 't' },
	{ "print-before-beginbytes",   required_argument, NULL, 'b' },
	{ "print-after-endbytes",      required_argument, NULL, 'a' },
	{ "version",                   no_argument,       NULL, 'V' },
	{ "help",                      no_argument,       NULL, 'h' },
        { 0,0,0,0 }
    };

    /* set defaults
    */
    options.bt.bytes="url=\""; options.bt.bytecount=5;
    options.et.bytes="\""; options.et.bytecount=1;
    options.pbbt.bytes=""; options.pbbt.bytecount=0;
    options.paet.bytes="\n"; options.paet.bytecount=1;

    /* duplicate array (enables us to overwrite argv[0])
    */
    argvv[0]="Error";
    for(n=1;n<argc;n++) { argvv[n]=argv[n]; } 

    /* initially, we assume: no options, no double options.
    */
    h=T=t=b=a=V=optdouble=0;

    /* parse options. Note, that each short option has an equivalent
     * long option.
     */
    while ( (c=getopt_long(argc,argvv,opts,long_options,(int*)0)) != -1)
    {
        switch(c) {
            case 'h':                                 /* help */
                    print_help(argv[0]);
                    break;
            case 'T':                                 /* beginbytes */
                    if (T==0) { 
                        esc(optarg,&options.bt);
                        T++;
                    } else optdouble++; 
                    break;
            case 't':                                 /* endbytes */
                    if (t==0) { 
                        esc(optarg,&options.et);
                        t++;
                    } else optdouble++; 
                    break;
            case 'b':                                 /* print before.. */
                    if (b==0) { 
                        esc(optarg,&options.pbbt);
                        b++;
                    } else optdouble++; 
                    break;
            case 'a':                                /* print after.. */
                    if (a==0) { 
                        esc(optarg,&options.paet);
                        a++;
                    } else optdouble++; 
                    break;
            case 'V':                               /* print version & exit */
		printf(CVSVERSION);
                exit(0);
                break;
            case '?':                               /* Muuuuuuhrm?? */
                exit(1);
                break;
        }
        if (optdouble>0) {
                fprintf(stderr,"%s: option specified before\n",argvv[0]);
                exit(1);
	}
    }

   return(&options);

} 
