#include "dbxurl.h"

/* header stuff
*/
#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <stdlib.h>

/* Convert the input buffer, which contains a NULL-terminated string that
 * may contain escape strings, into a BYTEBUFFER, that contains the binary
 * format and the length. This is implemented as a simple statemachine.
 */
void esc(char *input,BYTEBUFFER *output)
{
    char c;
    int i,j,state;

    /* resulting buffer will always fill less than the 
     * original, hence a buffer with the original length suffices
     */
    output->bytes=strdup(input);

    i=j=0;
    state=PRESLASH;

    while((c=input[i])!=(char)0) {

        switch(state) {


            case PRESLASH:
                 switch(c) {
		   case SLASH:
                        state=POSTSLASH;
                        break;

                   default:
                        output->bytes[j]=c;
                        j++;
                        break;
                 }
                 break;

            case POSTSLASH:
                 switch(c) {

		   case SLASH:
                        output->bytes[j]=SLASH;
                        break;

		   case 'n':
                        output->bytes[j]='\n';
                        break;

		   case 'r':
                        output->bytes[j]='\r';
                        break;

		   case 'f':
                        output->bytes[j]='\f';
                        break;

		   case 'v':
                        output->bytes[j]='\v';
                        break;

		   case 'b':
                        output->bytes[j]='\b';
                        break;

		   case '0':
                        output->bytes[j]='\0';
                        break;

		   case '(':
                        output->bytes[j]=fetchval(input,&i);
                        break;

                   default:
                        fail("argument contains illegal escape character");
                        output->bytes[j]='?';
                        break;

                 }
                 state=PRESLASH;
                 j++;
                 break;
        }

        i++; /* next input character */
    }

    output->bytecount=(size_t)j;
}

/*
 * This function tries to fetch a numerical value from the
 * input buffer. Initially, 'i' points to the opening bracket
 * '('. It is assumed this bracket is followed by a series of
 * digits, and the numerical string needs to be terminated by 
 * a closing bracket ')'. This function does not return if errors 
 * were found. If no errors were found, 'i' will point to the 
 * element in input that contains the closing bracket 
 * and the function will return the value found. 
 */
char fetchval(char *input, int *i)
{
        int k,digits,val;

        k=(*i)++;
        while( input[k]!=')' && input[k]) k++;
        digits=k-(*i);
        if (input[k]!=')') fail("numerical argument w/o closing bracket");
        for(k=0;k<digits;k++) 
        { 
           if (!isdigit(input[(*i)+k])) fail("non-digit in numerical argument");
        }
        val=atoi(&input[*i]);
        if (val>255) fail("numerical argument too big (>255)");
       
        *i += digits;

        return((char)val);
}
