/* Version
*/
#define CVSVERSION "$Id: dbxurl.h,v 1.1 2002/03/02 13:35:36 henk Exp $\n"

/* defines
*/
#define _GNU_SOURCE

/* everyones headers
*/
#include <stdio.h> 
#include <ctype.h>

/* some readabilities
*/
#define PRINT_NOTHING 0
#define PRINT_TOKEN 1
#define PRINT_NON_TOKEN 2
#define TOKEN 128
#define PRESLASH 4
#define POSTSLASH 8
#define SLASH '\\'

/* option structures
*/
typedef struct option_entry {
    unsigned char *bytes;
    size_t bytecount;
} BYTEBUFFER;

struct struct_options {
    BYTEBUFFER bt;	/* begin token + length */
    BYTEBUFFER et;      /* end token + length */
    BYTEBUFFER pbbt;    /* print before begintoken + length */
    BYTEBUFFER paet;    /* print after endtoken + length */
};

/* defined in getopt.h
*/
struct struct_options *options;

/* function declarations
*/
int locate(FILE *instream, FILE *outstream, BYTEBUFFER what, unsigned int flags);
void flush_buffer(FILE *outstream, char *buffer, unsigned int flags, int *i);
struct struct_options *get_options(int argc, char *const *argv);
void output(FILE *outstream,int c,unsigned int flags);
void esc(char *input,BYTEBUFFER *output);
void process_file(FILE *in, FILE *out);
int putbuffer(FILE *fp, BYTEBUFFER p);
void print_help(char *programname);
void process_stdin(FILE *out);
char fetchval(char *input,int *i);
void fail(char *e);
